<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio del Instituto de Corrosión y Protección</title>
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Laboratorio del Instituto de Corrosión y Protección' />
    <meta name='description' content='El Instituto de Corrosión y Protección de la Pontificia Universidad Católica del Perú (ICP-PUCP) es el único centro del país, especializado en la prestación de servicios de asesoría, inspección e investigación en el campo de la corrosión y la protección de materiales.'
    />
    <meta name='url' content='<?php echo $host; ?>laboratorio-corrosion-proteccion.php' />
    <meta name='keywords' content='INNOVAPUCP,Corrosión y Protección,investigación en el campo de la corrosión,protección de materiales,Pontificia Universidad Católica del Perú' />
    <!-- OpenGraph Meta Tags -->
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio del Instituto de Corrosión y Protección' />
    <meta property='og:description' content='El Instituto de Corrosión y Protección de la Pontificia Universidad Católica del Perú (ICP-PUCP) es el único centro del país, especializado en la prestación de servicios de asesoría, inspección e investigación en el campo de la corrosión y la protección de materiales.'
    />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-corrosion-proteccion.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body>
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorios del Instituto de Corrosión y Protección</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 titulo-xs">
                    <h1 class="visible-xs-block">Laboratorios del Instituto de Corrosión y Protección</h1>
                </div>
            </div>
            <div class="row">
                <div class=" col-sm-12 text-center">
                    <h3>El Instituto de Corrosión y Protección de la Pontificia Universidad Católica del Perú (ICP - PUCP) es el único en el país especializado en la asesoría, inspección e investigación en el campo de la corrosión y la protección de materiales. Asimismo, cuenta con acreditación ISO 17025:2005 por el Standards Council of Canada (SCC).</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <h3>El Instituto cuenta con 4 laboratorios y un área de ensayos especiales:</h3>
                    <ul>
                        <li><a href="http://icp.pucp.edu.pe/tipser/electroquimica/" target="_blank">Laboratorio de Electroquímica.</a></li>
                        <li><a href="http://icp.pucp.edu.pe/tipser/analisis-quimico/" target="_blank">Laboratorio de Análisis Químico.</a><br><em>* Este laboratorio cuenta con 1  tipo de ensayo acreditados con el ISO 17025:2005 por el Standards Council of Canada (SCC)</em></li>
                        <li><a href="http://icp.pucp.edu.pe/tipser/metalografia/" target="_blank">Laboratorio de Metalografía.</a></li>
                        <li><a href="http://icp.pucp.edu.pe/tipser/pinturas-corrosion-acelerada/" target="_blank">Laboratorio de Pinturas y Corrosión Acelerada.</a></li>
                        <li><a href="http://icp.pucp.edu.pe/tipser/ensayos-especiales/" target="_blank">Área de Ensayos Especiales de Corrosión.</a></li>
                    </ul>
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <h3>Los laboratorios del Instituto pueden realizar:</h3>
                    <ul>
                        <li> Medición de potenciales de electrodo y desarrollo de curvas de polarización.</li>
                        <li> Determinación de metales disueltos y totales por ICP-OES basada en EPA 200.7. </li>
                        <li> Análisis metalográfico y preparación de muestras para aceros y otras aleaciones.</li>
                        <li> Evaluación de resistencia a la corrosión acelerada en cámaras: niebla salina neutra, dióxido de azufre, climática o intemperismo.</li>
                        <li> Consultoría y asistencia técnica para el control de la corrosión en estructuras metálicas y concreto armado.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del Instituto de Corrosión y Protección <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                        <dl class="titulo"><dt>Contacto</dt>
                            <dd></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/05.png" alt="" /></dt>
                            <dd>
                                <strong>Lic. Isabel Díaz Tang</strong><br>
                                Directora del Instituto
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/02.png" alt="" /></dt>
                            <dd>(01) 626-2000 anexo 2510 | 3076
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/03.png" alt="" /></dt>
                            <dd> <a href="mailto:hgarcia@pucp.edu.pe">hgarcia@pucp.edu.pe</a></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/04.png" alt="" /></dt>
                            <dd> <a href="http://icp.pucp.edu.pe/" target="_blank">www.icp.pucp.edu.pe</a></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Indicators -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal" class="openform"><img src="img/corrosion/01.jpg" alt="innovapucp laboratorio corrosion 01" /></a>
                        <div id="modal" class="form">
                            <img class="img-responsive" src="img/corrosion/01.jpg" alt="innovapucp laboratorio corrosion 01" />
                            <p>Cámara de niebla salina para la simulación de ambientes marinos</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Cámara de niebla salina para la simulación de ambientes marinos</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_1" class="openform"><img src="img/corrosion/02.jpg" alt="innovapucp laboratorio corrosion 02" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/corrosion/02.jpg" alt="innovapucp laboratorio corrosion 02" />
                            <p>Colocación de materiales en bastidores para evaluación de corrosión atmosférica.</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Colocación de materiales en bastidores para evaluación de corrosión atmosférica</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/corrosion/03.jpg" alt="innovapucp laboratorio corrosion 03" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/corrosion/03.jpg" alt="innovapucp laboratorio corrosion 03" />
                            <p>Equipo ICP OES para el análisis de metales</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Equipo ICP OES para el análisis de metales</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_3" class="openform"><img src="img/corrosion/04.jpg" alt="innovapucp laboratorio corrosionn 04" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/corrosion/04.jpg" alt="innovapucp laboratorio corrosion 04" />
                            <p>CEquipo Perkin Elmer AS-90</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Equipo Perkin Elmer AS-90</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/corrosion/05.jpg" alt="innovapucp laboratorio corrosionn 05" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/corrosion/05.jpg" alt="innovapucp laboratorio corrosion 05" />
                            <p>Inspección de ácero corrugado en concreto armado</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Inspección de ácero corrugado en concreto armado</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_5" class="openform"><img src="img/corrosion/06.jpg" alt="innovapucp laboratorio corrosionn 06" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/corrosion/06.jpg" alt="innovapucp laboratorio corrosion 06" />
                            <p>Potenciostato Autolab 302N utilizado para la medición de velocidad de corrosión de metales</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Potenciostato Autolab 302N utilizado para la medición de velocidad de corrosión de metales</p>
                        </div>
                    </div>
                </div>
                <ol class="carousel-indicators">
                    <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="flecha-izquierda" />
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <img src="img/right.png" alt="flecha-derecha" />
                </a>
            </div>
        </div>
    </div>

    <?php include 'include/otros_laboratorios.php';?>
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>
    <script>
        $(document).ready(function() {
            $('.fancybox').fancybox();
            $(".openform").fancybox();
        });
    </script>
</body>

</html>
