<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio de Mecánica de Suelos</title>
    <meta name='title' content='INNOVAPUCP | Laboratorio de Mecánica de Suelos' />  
    <meta name='description' content='El Laboratorio de Mecánica de Suelos orienta y fortalece el desarrollo del conocimiento en el campo de la geotecnia: mecánica de suelos, ingeniería de cimentaciones y pavimentos. Actualmente, se disponen de 13 celdas para los ensayos triaxiales, que permite trabajar varios especímenes en forma simultánea y se realizan estudios de mecánica de suelos de acuerdo a la Norma NTE E-050 para el diseño de cimentaciones, pavimentos, peritajes y evaluaciones forenses geotécnicas.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-mecanica-de-suelos.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Mecánica de Suelos, orienta y fortalece el desarrollo del conocimiento en el campo de la geotecnia,mecánica de suelos,ingeniería de cimentaciones,ingeniería de pavimentos' />   
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Mecánica de Suelos' />
    <meta property='og:description' content='El Laboratorio de Mecánica de Suelos orienta y fortalece el desarrollo del conocimiento en el campo de la geotecnia: mecánica de suelos, ingeniería de cimentaciones y pavimentos. Actualmente, se disponen de 13 celdas para los ensayos triaxiales, que permite trabajar varios especímenes en forma simultánea y se realizan estudios de mecánica de suelos de acuerdo a la Norma NTE E-050 para el diseño de cimentaciones, pavimentos, peritajes y evaluaciones forenses geotécnicas.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-mecanica-de-suelos.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>  

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Mecánica de Suelos</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs"><h1 class="visible-xs-block">Laboratorios de Mecánica de Suelos</h1></div>
            </div>           
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="text-center">El Laboratorio de Mecánica de Suelos orienta y fortalece el desarrollo del conocimiento en el campo de la geotecnia, mecánica de suelos, ingeniería de cimentaciones y pavimentos. Está dirigido por  docentes especialistas. Actualmente, cuenta con 13 celdas para los ensayos triaxiales, que permiten trabajar varias muestras de forma simultánea y realizar estudios de mecánica de suelos de acuerdo a la Norma NTE E-050 para el diseño de cimentaciones, pavimentos, peritajes y evaluaciones forenses geotécnicas.</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <h3>Este laboratorio puede realizar:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li>Ensayos de clasificación y propiedades índices. </li>
                        <li>Ensayos para control y diseño. </li>
                        <li>Ensayos de compresión y extensión triaxiales, con o sin consolidación isotrópica o anisotrópica. </li>
                        <li>Análisis de suelos y materiales para pavimentación (grava, arena, limo o arcilla, piedra chancada, afirmado, entre otros). </li>
                        <li>Ensayos de humedad y materia orgánica. </li>
                    </ul>  
                </div>
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li>Estudios de mecánica de suelos de acuerdo a la norma sobre Suelos y Cimentaciones (E.050) del Reglamento Nacional de Edificaciones.</li>
                        <li>Diseño de pavimentos de acuerdo a las norma sobre Pavimentos Urbanos (CE. 010) del Reglamento Nacional de Edificaciones.</li> 
                        <li>Peritajes geotécnicos.</li> 
                        <li>Geotecnia forense.</li> 
                     </ul>       
                </div> 
            </div> 
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row separador-top">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br>
                    <div id="lista-contacto-dt-lab">
                       <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Ing. Manuel A. Olcese Franzero</strong><br>
                            Jefe del Laboratorio<br>
                            Departamento de Ingeniería - Sección ingeniería Civil
                        </dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 4651 | 4650
                        </dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd><a href="mailto:suelos@pucp.edu.pe">suelos@pucp.edu.pe</a></dd>                  
                      </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/mecanica-de-suelos/01.jpg" alt="innovapucp laboratorio mecanica suelos 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/01.jpg" alt="innovapucp laboratorio mecanica suelos 01" />
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_2" class="openform"> <img src="img/mecanica-de-suelos/02.jpg"  alt="innovapucp laboratorio mecanica suelos 02" /></a>
                        <div id="modal_2" class="form">
                             <img class="center-block img-responsive" src="img/mecanica-de-suelos/02.jpg"  alt="innovapucp laboratorio mecanica suelos 02" />
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_3" class="openform"><img src="img/mecanica-de-suelos/03.jpg"  alt="innovapucp laboratorio mecanica suelos 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/03.jpg"  alt="innovapucp laboratorio mecanica suelos 03" />
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>

                    <div class="item">

                        <a href="#modal_4" class="openform"><img src="img/mecanica-de-suelos/04.jpg"  alt="innovapucp laboratorio mecanica suelos 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/04.jpg"  alt="innovapucp laboratorio mecanica suelos 04" />
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>
                    <div class="item">


                        <a href="#modal_5" class="openform"><img src="img/mecanica-de-suelos/05.jpg"  alt="innovapucp laboratorio mecanica suelos 05" /></a>
                        <div id="modal_5" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/05.jpg"  alt="innovapucp laboratorio mecanica suelos 05" />
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_6" class="openform"> <img src="img/mecanica-de-suelos/06.jpg"  alt="innovapucp laboratorio mecanica suelos 06" /></a>
                        <div id="modal_6" class="form">
                             <img class="center-block img-responsive" src="img/mecanica-de-suelos/06.jpg"  alt="innovapucp laboratorio mecanica suelos 06" />
                             <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                             <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_7" class="openform"><img src="img/mecanica-de-suelos/07.jpg"  alt="innovapucp laboratorio mecanica suelos 07" /></a>
                        <div id="modal_7" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/07.jpg"  alt="innovapucp laboratorio mecanica suelos 07" />
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                    </div>
                     <div class="item">
                        <a href="#modal_8" class="openform"> <img src="img/mecanica-de-suelos/08.jpg"  alt="innovapucp laboratorio mecanica suelos 08" /></a>
                        <div id="modal_8" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/08.jpg"  alt="innovapucp laboratorio mecanica suelos 08" />
                             <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                        <div class="carousel-caption">    
                             <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>
                     <div class="item">

                        <a href="#modal_9" class="openform"><img src="img/mecanica-de-suelos/09.jpg" alt="innovapucp laboratorio mecanica suelos 09" /></a>
                        <div id="modal_9" class="form">
                            <img class="center-block img-responsive" src="img/mecanica-de-suelos/09.jpg" alt="innovapucp laboratorio mecanica suelos 09" />
                           <p>Laboratorio Mecánica de Suelos</p>
                        </div>

                        <div class="carousel-caption">    
                           <p>Laboratorio Mecánica de Suelos</p>
                        </div>
                    </div>
                </div>

                <ol class="carousel-indicators">
                  <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="6"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="7"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="8"></li>
               
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="" />
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <img src="img/right.png" alt="" />
                </a>
            </div>
        </div> 
    </div>
    
    <?php include 'include/otros_laboratorios.php';?>   
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

    <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
    </script>
</body>
</html>
